clear
capture log close
log using fig12.txt, replace



*use "SIPP"

***full-time steady****

gen fts_dummy = 0
replace fts_dummy= 1 if (rmesr==1 & eptwrk==2 | rmesr ==2 & eptwrk==2) 

***Employed****

gen any_emp_dummy = 0
replace any_emp_dummy = 1 if rmesr==1 | rmesr==2 | rmesr==3 | rmesr==4 | rmesr==5 | rmesr==6

****Unemployed****

gen unemployed_dummy=0
replace unemployed_dummy =1 if rmesr==6 | rmesr==7

*gen not_emp_dummy = 0 
*replace not_emp_dummy = 1 if any_emp_dummy==0

****Not in the Labor Force****

gen not_lf_dummy = 0
replace not_lf_dummy = 1 if rmesr ==8



egen panel_id = group(ssuid eentaid epppnum)



sort 	panel_id rhcalyr rhcalmn

gen date=ym(rhcalyr, rhcalmn)

format date %tm

by panel_id (date), sort: gen survey_appear = _n


sort panel_id date 
xtset panel_id date

foreach var in fts_dummy any_emp_dummy unemployed_dummy not_lf_dummy  {

tsspell `var'

replace _seq = 0 if `var'==0
rename _seq `var'_dur

rename _spell `var'_spell

drop _end
}

**other part****

*create alt measure for not employed
gen not_emp_dummy = unemployed_dummy

*The basic idea here is you want to know when an unemployed month is followed by
*a not_lf month.
*So make a dummy for unemployed followed by not_lf. A 1 means a not_lf_month 
*that was preceeded by unemployed.

gen u_nlf_switch = 0
replace u_nlf_switch = 1 if L.unemployed_dummy == 1 & not_lf_dummy == 1

*Now, if a month has a 1 (which means it is the beginning of a not_lf spell that
*was preceeded by an unemployed month, you want to identify all subsequent 
*months in that not_lf spell.  So all of those subsequent not_lf months are 1.

bysort panel_id not_lf_dummy_spell (date): egen switch_spell = total(u_nlf_switch)

*Now we add those months identified as "1" to your not employed measure
replace not_emp_dummy = not_lf_dummy if switch_spell == 1

*Now we have our not employed dummy.  We do the same spell measurements

tsspell not_emp_dummy

rename _seq not_emp_dummy_dur
rename _end not_emp_dummy_end
rename _spell not_emp_dummy_spell

replace not_emp_dummy_dur = 0 if not_emp_dummy == 0

*Same problem with spells that are ongoing when the survey begins.  This erases
*all spells that are ongoing at the time of survey
replace not_emp_dummy_dur = 0 if not_emp_dummy_dur == survey_appear

save for_spell_not_employed.dta, replace
*****

******

local 	non_emp_dur_measure		not_emp_dummy_dur
local 	non_emp_spell_measure		not_emp_dummy_spell


*****
*SIPP Survey time period
local 	time_period 	2008/2013

*Choose the lead value
local	lead	15

*Open SIPP Survey data
*use 	"cleaned_spell.dta", clear

sort 	panel_id date

*Only count one spell per person per year
*Delete other spells that begin in the same year

gen 	spell_start 	= 0
replace spell_start 	= 1 		if `non_emp_dur_measure' == 1

gen 	spell_start_y	= 0
replace spell_start_y 	= rhcalyr 	if `non_emp_dur_measure' == 1
bysort 	panel_id `non_emp_spell_measure' (date): egen spell_start_year = max(spell_start_y)

gen 	first_mon_indic	= 	1 		if `non_emp_dur_measure' ==	1
bysort 	panel_id rhcalyr (date): 	gen first_mon_count = sum(first_mon_indic)
bysort 	panel_id `non_emp_spell_measure' (date): egen spell_number = max(first_mon_count)
replace spell_number 	= 	0 		if `non_emp_dur_measure' == 0		
sort 	panel_id date				

*Designate the first month of spell
gen 	first_mon = 0
replace first_mon = 1 if `non_emp_dur_measure' == 1

*Raw count of outcomes `LEAD' months ahead
foreach var in 	fts_dummy			///
				any_emp_dummy	 	///
				unemployed_dummy 	///
				not_lf_dummy		{
gen 	fift_`var' = .
replace fift_`var' = F`lead'.`var' if first_mon == 1
}
*

*Weighted count of outcomes `LEAD' months ahead
gen 		first_mon_w = 0
replace 	first_mon_w = wpfinwgt if `non_emp_dur_measure' == 1
foreach 	var in 	fts_dummy			///
					any_emp_dummy	 	///
					unemployed_dummy 	///
					not_lf_dummy		{
gen 		fift_w_`var' = .
replace 	fift_w_`var' = F`lead'.`var'*wpfinwgt if first_mon == 1
}
*

*Only count full-time steady employment if employed for at least 4 consecutive months
replace fift_w_fts_dummy	=	0  if F15.fts_dummy_dur<4 		

sort 		panel_id date
		
*Drop if not jobless or 15 month lead outcome missing
keep 	if 	`non_emp_dur_measure' == 1 	
drop if 	fift_fts_dummy 	== .

*Print Results
foreach v in	first_mon_w					///
				fift_w_fts_dummy 			///
				fift_w_any_emp_dummy 		///
				fift_w_unemployed_dummy 	///
				fift_w_not_lf_dummy 		{
forval 	y 	= `time_period'					{
qui 	sum `v' if  rhcalyr	==`y' & spell_number==1
di 		"`lead'" "ALL-SPELLS" "  " "`y'" "   " r(sum)
}
}
